﻿//////////////////////////////////////////////
// ProgramManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/InfiniteMask.h"
#include "../Utils/Manager.h"

#include "Program.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>
	
/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ProgramManager final : public Manager<Program>, public nkCommon::MaybeSingletonClass<ProgramManager>
	{			
		private :

			// Constructors
			ProgramManager (bool isSingleton) noexcept ;
			ProgramManager (System* system) noexcept ;

		private :

			// Attributes
			unsigned int _programCounter ;

		private :

			friend class nkCommon::MaybeSingletonClass<ProgramManager> ;
			friend class System ;
	} ;
}